package org.kar.demo

import java.text.SimpleDateFormat
import org.kar.demo.SimpleInterface
import org.kar.demo.DelegateDemo
import org.kar.demo.SimpleInterfaceImpl1;

class MOPTest extends GroovyTestCase
{
    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd")

    void testMapCoercionInterfaces()
    {
        //closure will be called for ANY method call on the interface
        def simpleImpl = {'hello world'} as SimpleInterface

        assertEquals('hello world', simpleImpl.sayHelloWorld())
        assertEquals('hello world', simpleImpl.saySomethingElse())

        //each method mapped to a closure
        simpleImpl = [sayHelloWorld : {'hello world'}, saySomethingElse : {'something else'}] as SimpleInterface

        assertEquals('hello world', simpleImpl.sayHelloWorld())
        assertEquals('something else', simpleImpl.saySomethingElse())
    }

    void testExpandoMetaClass()
    {
        //add a method to the String class dynamically
        String.metaClass.aliasReverse = { delegate.reverse() }

        String test = 'test'
        assertEquals(test.aliasReverse(), test.reverse())
        log.info (test.metaClass.methods.find{it.name.contains('alias')}.toString())
    }

    void testDelegateAST()
    {
        StringBuffer buffer = new StringBuffer()
        Date date = new Date()

        //method calls on this object are delegated to its member variables
        DelegateDemo delegateDemo = new DelegateDemo(when : date, buffer : buffer)

        //call on the buffer
        delegateDemo.append(delegateDemo.getTime())

        assertEquals(date.getTime().toString(), buffer.toString())

        Date olderDate = df.parse('1999/01/01')

        //call on the date
        assertTrue(delegateDemo.after(olderDate))

        assertEquals(date, delegateDemo.when)
        assertEquals(buffer, delegateDemo.buffer)
    }

    void testCategoryAndMixin()
    {
        SimpleInterface simpleInterface = new SimpleInterfaceImpl1()

        assertEquals('another thing', simpleInterface.sayAnotherThing())
    }

}