package org.kar.demo;

class GDKSyntacticSugarTest extends GroovyTestCase
{
    void testLists()
    {
        def list = []
        assertEquals(ArrayList.class, list.class)

        //new operators
        list << 'a'
        assertTrue(list.size() == 1 && list[0] == 'a')

        list += 'b'
        assertTrue(list.size() == 2 && list[0] == 'a' && list[1] == 'b')

        list -= 'a'
        assertTrue(list.size() == 1 && list[0] == 'b')

        //sneaking in one of the adds to Number
        5.times { list << it }

        assertEquals(6, list.size())

        assertEquals([4,3,2,1,0,'b'], list.reverse())

        list.eachWithIndex { it, index ->
            log.info("$it is at index $index")
        }
        assertEquals(['b'], list - [0,1,2,3,4])
    }

    void testMaps()
    {
        //inline definition and . syntax for lookups
        def map = [one:1, two:2]
        assertEquals (2, map.size())
        assertEquals(1,map.one)
        assertEquals (2, map.two)

        map.each { key, value ->
            log.info("The value for $key is $value")
        }
    }
}